/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.oauth2;

import cn.com.duiba.application.boot.api.domain.model.OauthInfo;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationBootOauth2Client {
    private static final Logger log = LoggerFactory.getLogger(ApplicationBootOauth2Client.class);
    private String state = UUIDUtils.createSecureUUID();
    private LoadingCache<String, String> cache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, String>(){

        @Nullable
        public String load(@Nonnull String s) {
            return ApplicationBootOauth2Client.this.loadOauthToken();
        }
    });
    private LoadingCache<String, OauthInfo> authInfocache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, OauthInfo>(){

        @Nullable
        public OauthInfo load(@Nonnull String accessToken) throws Exception {
            return ApplicationBootOauth2Client.this.loadOauthInfo(accessToken);
        }
    });

    public String getAccessToken() {
        try {
            return (String)this.cache.get((Object)"$$thisApplication");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6AccessToken\u5931\u8d25", (Throwable)e);
            return "";
        }
    }

    public OauthInfo getOauthInfo(String accessToken) {
        return (OauthInfo)this.authInfocache.get((Object)accessToken);
    }

    public abstract String loadOauthToken();

    public abstract OauthInfo loadOauthInfo(String var1);

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }
}

