/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.mappingmode;

import cn.com.duiba.application.boot.api.component.mappingmode.MappingModeProperties;
import cn.com.duiba.application.boot.api.component.oauth2.ApplicationBootOauth2Client;
import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import com.google.common.collect.Sets;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.annotation.Order;

@Order(value=1)
public class MappingModePlugin
implements RequestInterceptor {
    @Resource
    private MappingModeProperties mappingModeProperties;
    @Resource
    private ApplicationBootOauth2Client applicationBootOauth2Client;
    private Set<String> appNames = Sets.newHashSet();
    static final String X_MAPPING_MODE_OAUTH2 = "X-MAPPING-MODE-AUTH";
    static final String X_MAPPING_MODE_STATE = "X-MAPPING-MODE-STATE";

    @PostConstruct
    public void init() {
        this.appNames.addAll(this.mappingModeProperties.getMappingMode().keySet());
    }

    public void apply(RequestTemplate template) {
        String sourceServiceId = RpcContext.getContext().getSourceServiceId();
        String targetServiceId = RpcContext.getContext().getTargetServiceId();
        if (!this.appNames.contains(targetServiceId) || StringUtils.equals((String)sourceServiceId, (String)targetServiceId)) {
            return;
        }
        template.header(X_MAPPING_MODE_OAUTH2, new String[]{this.applicationBootOauth2Client.getAccessToken()});
        template.header(X_MAPPING_MODE_STATE, new String[]{this.applicationBootOauth2Client.getState()});
    }
}

