package cn.com.duiba.application.boot.api.component.mappingmode;

import cn.com.duiba.application.boot.api.component.oauth2.ApplicationBootOauth2Client;
import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import com.google.common.collect.Sets;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.annotation.Order;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.Set;

/**
 * 映射模式插件
 * 1.修改请求地址
 * 2.生成请求签名
 */
@Order(1)
public class MappingModePlugin implements RequestInterceptor {

    @Resource
    private MappingModeProperties mappingModeProperties;
    @Resource
    private ApplicationBootOauth2Client applicationBootOauth2Client;

    private Set<String> appNames = Sets.newHashSet();

    static final String X_MAPPING_MODE_OAUTH2 = "X-MAPPING-MODE-AUTH";//映射模式签名
    static final String X_MAPPING_MODE_STATE = "X-MAPPING-MODE-STATE";

    @PostConstruct
    public void init(){
        appNames.addAll(mappingModeProperties.getMappingMode().keySet());
    }

    @Override
    public void apply(RequestTemplate template) {

        String sourceServiceId = RpcContext.getContext().getSourceServiceId();
        String targetServiceId = RpcContext.getContext().getTargetServiceId();

        if(!appNames.contains(targetServiceId) || StringUtils.equals(sourceServiceId,targetServiceId)){
            return;
        }
        template.header(X_MAPPING_MODE_OAUTH2,applicationBootOauth2Client.getAccessToken());
        template.header(X_MAPPING_MODE_STATE, applicationBootOauth2Client.getState());
    }

}
