package cn.com.duiba.application.boot.api.component.mappingmode;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import javax.annotation.Resource;

@Configuration
@Order(-3)
public class MappingModeServerConfiguration extends WebMvcConfigurerAdapter {

    @Resource
    private MappingModeServerInterceptor mappingModeServerInterceptor;

    @Bean
    public MappingModeServerInterceptor mappingModeServerInterceptor(){
        return new MappingModeServerInterceptor();
    }

    @Bean
    public MappingModeXssDefensivePolicy mappingModeXssDefensivePolicy(){
        return new MappingModeXssDefensivePolicy();
    }


    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(mappingModeServerInterceptor).addPathPatterns("/**");
    }




}
