package cn.com.duiba.application.boot.api.remoteservice;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.domain.dto.AllocationResultDto;
import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.application.boot.api.domain.dto.ApplicationOwnerConfigDto;
import cn.com.duiba.application.boot.api.domain.enums.AdminApplicationRelation;
import cn.com.duiba.application.boot.api.domain.enums.ApplicationPermissionType;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteApplicationPermissionService {

    /**
     * 应用与人员之间的关系
     */
    List<ApplicationOwnerConfigDto> batchFindAppOwners(List<String> appAliasList);

    /**
     * 构建关系
     */
    void buildRelation(Long adminId, String appAlias, AdminApplicationRelation relation) throws BizException;
    /**
     * 撤销关系
     */
    void dismissRelation(Long adminId,String appAlias,AdminApplicationRelation relation) throws BizException;

    Set<String> findAppAliasByAdminAndRelation(Long adminId, AdminApplicationRelation relation);

    Set<Long> findAdminIdByAppAliasAndRelation(String appAlias,AdminApplicationRelation relation);

    /**
     * 应用与人员之间的之间的权限
     */
    Set<String> findApplicationPermissionByAdminId(Long adminId,Environment environment,ApplicationPermissionType permissionType);

    Map<Long,Set<Environment>> findAllApplicationPermissionInAdminIdAndAppAlias(List<Long> adminIds,String appAlias,ApplicationPermissionType relation);

    Set<Long> findApplicationPermissionByAppAlias(String appAlias,Environment environment,ApplicationPermissionType permissionType);

    Boolean toggetApplicationPermission(Long adminId,String appAlias,Environment environment, ApplicationPermissionType permissionType);

    AllocationResultDto<ApplicationDto> configApplicationPermissionByAppAlias(Long adminId, Set<String> appAlias, Environment environment, ApplicationPermissionType permissionType);


}
