package cn.com.duiba.application.boot.api.remoteservice;

import cn.com.duiba.application.boot.api.domain.dto.OrganizationDto;
import cn.com.duiba.application.boot.api.domain.enums.AdminOrganizationRelation;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteOrganizationService {

    OrganizationDto find(Long orgId);
    /**
     * 获取所有的业务线
     */
    List<OrganizationDto> findAllOrganization();

    /**
     * 获取每个组织下app的总数
     */
    Map<Long,Integer> findAppCountMapForOrganization();


    void saveOrganization(OrganizationDto organization);

    /**
     * 配置业务线主管人员
     */
    void configOrganizationPersonnel(Long orgId, List<Long> adminIds, AdminOrganizationRelation relation);

    Set<Long> findOrganizationByAdminId(Long adminId, AdminOrganizationRelation relation);

    Set<Long> findAdminByOrganizationId(Long orgId, AdminOrganizationRelation relation);

    Map<Long,Set<Long>>  batchFindBolRelation(List<Long> orgIds,AdminOrganizationRelation relation);

}
