/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.environment;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum Environment implements Serializable
{
    DEV(1L, "dev", "\u5f00\u53d1\u73af\u5883", 1),
    TEST(2L, "test", "\u6d4b\u8bd5\u73af\u5883", 2),
    PRE(4L, "pre", "\u9884\u53d1\u73af\u5883", 3),
    PROD(3L, "prod", "\u751f\u4ea7\u73af\u5883", 4);

    private final Long id;
    private final String envId;
    private final String envName;
    private final Integer weight;

    private Environment(Long id, String envId, String envName, Integer weight) {
        this.id = id;
        this.envId = envId;
        this.envName = envName;
        this.weight = weight;
    }

    public static Environment getEnvByEnvId(String envId) {
        Objects.requireNonNull(envId);
        switch (envId) {
            case "dev": {
                return DEV;
            }
            case "test": {
                return TEST;
            }
            case "pre": {
                return PRE;
            }
            case "prod": {
                return PROD;
            }
        }
        return PROD;
    }

    public static Environment getEnvById(Long id) {
        Objects.requireNonNull(id);
        int indexForInt = id.intValue();
        switch (indexForInt) {
            case 1: {
                return DEV;
            }
            case 2: {
                return TEST;
            }
            case 4: {
                return PRE;
            }
            case 3: {
                return PROD;
            }
        }
        return PROD;
    }

    public static Environment getEnvByPrefix(String prefix) {
        for (Environment env : Environment.values()) {
            if (!StringUtils.startsWith((CharSequence)prefix, (CharSequence)env.getEnvId())) continue;
            return env;
        }
        return null;
    }

    public static Boolean isOnline(Environment environment) {
        return Objects.equals(environment, PROD) || Objects.equals(environment, PRE);
    }

    public static Environment parseEnvironmentEnum(String profiles) {
        if (StringUtils.isBlank((CharSequence)profiles)) {
            return PROD;
        }
        for (Environment environment : Environment.values()) {
            if (!StringUtils.startsWith((CharSequence)profiles, (CharSequence)environment.getEnvId())) continue;
            return environment;
        }
        return PROD;
    }

    public Long getId() {
        return this.id;
    }

    public String getEnvId() {
        return this.envId;
    }

    public String getEnvName() {
        return this.envName;
    }

    public Integer getWeight() {
        return this.weight;
    }
}

