/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.environment;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.domain.dto.ClusterDto;
import cn.com.duiba.application.boot.api.remoteservice.RemoteClusterService;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.util.StringUtils;

public class EnvironmentService {
    private static final String CLUSTER_PREFIX = "cluster_";
    public static final String DEFAULT_CLUSTER_KEY = "default";
    @Resource
    private RemoteClusterService remoteClusterService;
    @Resource
    private Environment currentEnvironment;
    @Resource
    private org.springframework.core.env.Environment environment;
    private String clusterKey = "default";

    @PostConstruct
    public void init() {
        String profiles = this.environment.getProperty("spring.profiles.active", Environment.DEV.getEnvId());
        String[] profileArray = StringUtils.commaDelimitedListToStringArray((String)profiles);
        this.clusterKey = DEFAULT_CLUSTER_KEY;
        for (String profile : profileArray) {
            if (!StringUtils.startsWithIgnoreCase((String)profile, (String)CLUSTER_PREFIX)) continue;
            this.clusterKey = profile.replace(CLUSTER_PREFIX, "");
        }
    }

    public ClusterDto currentCluster() {
        return this.remoteClusterService.findByUK(this.currentEnvironment, this.clusterKey);
    }

    public String currentClusterKey() {
        return this.clusterKey;
    }
}

