/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.environment;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import cn.com.duiba.application.boot.api.domain.dto.ClusterDto;
import cn.com.duiba.application.boot.api.remoteservice.RemoteClusterService;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.StringUtils;

@Configuration
public class ApplicationBootEnvironmentConfiguration {
    private static final String CLUSTER_PREFIX = "cluster#";
    private static final String DEFAULT_CLUSTER_KEY = "default";
    @Resource
    private ApplicationContext applicationContext;

    @Bean
    public Environment currentEnvironment(org.springframework.core.env.Environment environment) {
        String[] profileArray;
        String profiles = environment.getProperty("spring.profiles.active", Environment.DEV.getEnvId());
        for (String profile : profileArray = StringUtils.commaDelimitedListToStringArray((String)profiles)) {
            Environment current = Environment.getEnvByPrefix(profile);
            if (!Objects.nonNull(current)) continue;
            return current;
        }
        return Environment.DEV;
    }

    @Bean
    @ConditionalOnMissingBean(value={RequestEnvironmentDecisionMaker.class})
    public RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker() {
        return new RequestEnvironmentDecisionMaker();
    }

    @Bean
    @Lazy
    public ClusterDto currentCluster(org.springframework.core.env.Environment environment, Environment currentEnvironment) {
        String profiles = environment.getProperty("spring.profiles.active", Environment.DEV.getEnvId());
        String[] profileArray = StringUtils.commaDelimitedListToStringArray((String)profiles);
        String clusterKey = DEFAULT_CLUSTER_KEY;
        for (String profile : profileArray) {
            if (!StringUtils.startsWithIgnoreCase((String)profile, (String)CLUSTER_PREFIX)) continue;
            clusterKey = profile.replace(CLUSTER_PREFIX, "");
        }
        RemoteClusterService remoteClusterService = (RemoteClusterService)this.applicationContext.getBean(RemoteClusterService.class);
        ClusterDto clusterDto = remoteClusterService.findByUK(currentEnvironment, clusterKey);
        if (Objects.isNull(clusterDto)) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u96c6\u7fa4\u6807\u8bb0\uff1a" + clusterKey);
        }
        return clusterDto;
    }
}

