/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.mappingmode;

import cn.com.duiba.application.boot.api.ApplicationProperties;
import cn.com.duiba.application.boot.api.component.mappingmode.MappingModeProperties;
import cn.com.duiba.application.boot.api.component.oauth2.ApplicationBootOauth2Client;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.google.common.collect.Sets;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class MappingModePlugin
implements RequestInterceptor {
    @Resource
    private ApplicationProperties applicationProperties;
    @Resource
    private MappingModeProperties mappingModeProperties;
    @Resource
    private ApplicationBootOauth2Client applicationBootOauth2Client;
    private Set<String> appNames = Sets.newHashSet();
    private static ThreadLocal<Boolean> INVOKE_FLAG = new TransmittableThreadLocal();
    public static final String X_MAPPING_MODE_OAUTH2 = "X-MAPPING-MODE-AUTH";
    public static final String X_MAPPING_MODE_STATE = "X-MAPPING-MODE-STATE";

    @PostConstruct
    public void init() {
        this.appNames.addAll(this.mappingModeProperties.getMappingMode().keySet());
    }

    public void apply(RequestTemplate template) {
        if (!this.isMappingInvoke().booleanValue()) {
            return;
        }
        template.header(X_MAPPING_MODE_OAUTH2, new String[]{this.applicationBootOauth2Client.getAccessToken()});
        template.header(X_MAPPING_MODE_STATE, new String[]{this.applicationBootOauth2Client.getState()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@within(cn.com.duiba.boot.netflix.feign.AdvancedFeignClient)")
    public Object mappingModeRoute(ProceedingJoinPoint joinPoint) throws Throwable {
        Class<?> targetClass = joinPoint.getTarget().getClass();
        AdvancedFeignClient client = (AdvancedFeignClient)AnnotationUtils.findAnnotation(targetClass, AdvancedFeignClient.class);
        String appName = client.value();
        INVOKE_FLAG.set(this.appNames.contains(appName) && !StringUtils.equals((String)appName, (String)this.applicationProperties.getName()));
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            INVOKE_FLAG.remove();
        }
    }

    Boolean isMappingInvoke() {
        return Optional.ofNullable(INVOKE_FLAG.get()).orElse(false);
    }
}

