/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.mappingmode;

import cn.com.duiba.application.boot.api.component.mappingmode.MappingModePlugin;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=2)
public class MappingModeSleathPlugin
implements RequestInterceptor {
    @Resource
    private Tracer tracer;
    @Resource
    private MappingModePlugin mappingModePlugin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@within(cn.com.duiba.boot.netflix.feign.AdvancedFeignClient)")
    public Object invoke(ProceedingJoinPoint joinPoint) throws Throwable {
        if (!this.mappingModePlugin.isMappingInvoke().booleanValue()) {
            return joinPoint.proceed();
        }
        if (!this.tracer.isTracing() || !this.tracer.getCurrentSpan().isExportable()) {
            return joinPoint.proceed();
        }
        Class<?> targetClass = joinPoint.getTarget().getClass();
        AdvancedFeignClient client = (AdvancedFeignClient)AnnotationUtils.findAnnotation(targetClass, AdvancedFeignClient.class);
        String appName = client.value();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        Span span = this.tracer.createSpan(appName + ":/" + methodName);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(targetClass.getSimpleName()).append(".").append(methodName);
        try {
            span.tag("mappingmode.class_method", stringBuilder.toString());
            span.tag("lc", "app-boot-mappingmode");
            span.tag("peer.service", appName);
            span.logEvent("cs");
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            span.logEvent("cr");
            this.tracer.close(span);
        }
    }

    public void apply(RequestTemplate template) {
        if (this.mappingModePlugin.isMappingInvoke().booleanValue()) {
            template.header("X-B3-Flags", new String[]{"0"});
        }
    }
}

