/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.oauth2;

import cn.com.duiba.application.boot.api.ApplicationProperties;
import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.mappingmode.MappingModeProperties;
import cn.com.duiba.application.boot.api.component.oauth2.ApplicationBootOauthProperties;
import cn.com.duiba.application.boot.api.domain.model.OauthInfo;
import cn.com.duiba.application.boot.api.domain.model.OauthToken;
import cn.com.duiba.application.boot.api.domain.model.OauthTokenRequest;
import cn.com.duiba.wolf.utils.UUIDUtils;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class ApplicationBootOauth2Client {
    private static final Logger log = LoggerFactory.getLogger(ApplicationBootOauth2Client.class);
    @Resource
    public RestTemplate oauthRestTemplate;
    @Resource
    public MappingModeProperties mappingModeProperties;
    @Resource
    private ApplicationBootOauthProperties applicationBootOauthProperties;
    @Resource
    private ApplicationProperties applicationProperties;
    @Resource
    private Environment currentEnvironment;
    private final String state = UUIDUtils.createSecureUUID();
    private LoadingCache<String, String> cache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, String>(){

        @Nullable
        public String load(@Nonnull String s) {
            OauthTokenRequest request = new OauthTokenRequest();
            request.setAppAlias(ApplicationBootOauth2Client.this.applicationProperties.getName());
            request.setAppSecret(ApplicationBootOauth2Client.this.applicationProperties.getSecret());
            request.setEnvironment(ApplicationBootOauth2Client.this.currentEnvironment.getEnvId());
            request.setState(ApplicationBootOauth2Client.this.state);
            OauthToken token = (OauthToken)ApplicationBootOauth2Client.this.oauthRestTemplate.postForObject(ApplicationBootOauth2Client.this.buildHost("/oauth/getAccessToken"), (Object)request, OauthToken.class, new Object[0]);
            if (StringUtils.isBlank((String)token.getAccessToken())) {
                throw new RuntimeException("\u83b7\u53d6accessToken\u5931\u8d25");
            }
            if (!StringUtils.equals((String)ApplicationBootOauth2Client.this.state, (String)token.getState())) {
                throw new RuntimeException("\u83b7\u53d6accessToken\u9a8c\u8bc1\u5931\u8d25");
            }
            return token.getAccessToken();
        }
    });
    private LoadingCache<String, OauthInfo> authInfocache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, OauthInfo>(){

        @Nullable
        public OauthInfo load(@Nonnull String accessToken) throws Exception {
            return (OauthInfo)ApplicationBootOauth2Client.this.oauthRestTemplate.getForObject(ApplicationBootOauth2Client.this.buildHost("/oauth/authorize") + "?accessToken=" + accessToken, OauthInfo.class, new Object[0]);
        }
    });

    public String getAccessToken() {
        try {
            return (String)this.cache.get((Object)"$$thisApplication");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6AccessToken\u5931\u8d25", (Throwable)e);
            return "";
        }
    }

    public OauthInfo getOauthInfo(String accessToken) {
        return (OauthInfo)this.authInfocache.get((Object)accessToken);
    }

    public String getState() {
        return this.state;
    }

    private String buildHost(String path) {
        String host = Optional.ofNullable(this.applicationBootOauthProperties.getHost()).orElse("http://" + this.mappingModeProperties.getMappingMode().get("application-boot"));
        return host + path;
    }
}

