package cn.com.duiba.application.boot.api;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import lombok.Data;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@Data
@ConfigurationProperties(prefix = "spring.application")
public class ApplicationProperties {

    private String name;

    private String secret;

    private Environment environment;

    private String priorName;

    public String getApplicationName(){
        if(StringUtils.isNotBlank(priorName)){
            return priorName;
        }
        return name;
    }

}
