package cn.com.duiba.application.boot.api.component.environment;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.util.StringUtils;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

/**
 * @author liuyao
 */
@Slf4j
public class EnvironmentService {

    private static final String CLUSTER_PREFIX = "cluster_";
    public static final String DEFAULT_CLUSTER_KEY = "default";

    @Resource
    private org.springframework.core.env.Environment environment;
    @Resource
    private Environment currentEnvironment;

    private String clusterKey = DEFAULT_CLUSTER_KEY;

    @PostConstruct
    public void init(){

        log.info("当前环境:"+currentEnvironment.getEnvName());

        String profiles = environment.getProperty(ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY,Environment.DEV.getEnvId());
        String[] profileArray = StringUtils.commaDelimitedListToStringArray(profiles);
        clusterKey = DEFAULT_CLUSTER_KEY;
        for(String profile:profileArray){
            if(StringUtils.startsWithIgnoreCase(profile,CLUSTER_PREFIX)){
                clusterKey = profile.replace(CLUSTER_PREFIX,"");
            }
            if(StringUtils.startsWithIgnoreCase(profile,"dev")){
                clusterKey = "dev";
            }
            if(StringUtils.startsWithIgnoreCase(profile,"pre")){
                clusterKey = "pre";
            }
        }
    }

    public String currentClusterKey(){
        return clusterKey;
    }

    public Environment getCurrentEnvironment(){
        return currentEnvironment;
    }

}
