package cn.com.duiba.application.boot.api.component.mappingmode;

import brave.Tracer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(name = "application.boot.mapping-mode-enable",havingValue = "true",matchIfMissing = true)
@EnableConfigurationProperties(MappingModeProperties.class)
public class MappingModeConfiguration {

    @Bean
    public MappingModePlugin mappingModePlugin(){
        return new MappingModePlugin();
    }

    @Configuration
    @ConditionalOnClass(Tracer.class)
    public static class MappingModeSleathPluginConfiguration{

        @Bean
        public MappingModeSleathPlugin mappingModeSleathPlugin(){
            return new MappingModeSleathPlugin();
        }

    }




}
