package cn.com.duiba.application.boot.api.component.mappingmode;


import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import cn.com.duiba.application.boot.api.component.oauth2.ApplicationBootOauth2Client;
import cn.com.duiba.application.boot.api.domain.model.OauthInfo;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.CustomRequestInterceptor;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Slf4j
public class MappingModeServerInterceptor extends HandlerInterceptorAdapter {

    public static final String APP_BOOT_MAPPING_MODE = "APP_BOOT_MAPPING_MODE";

    @Resource
    private RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker;
    @Resource
    private ApplicationBootOauth2Client applicationBootOauth2Client;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws BizException {
        //不是远程调用直接
        if (!Boolean.valueOf(request.getHeader(CustomRequestInterceptor.X_RPC))) {
            return true;
        }
        String accessToken = request.getHeader(MappingModePlugin.X_MAPPING_MODE_OAUTH2);

        //是feign调用的情况下还得验证请求来自内网，否则会有安全问题
        if(HttpRequestUtils.isLanRequest(request) && StringUtils.isBlank(accessToken)){
            return true;
        }
        //关闭压测模式
        PerfTestContext._setPerfTestMode(false);

        String state = request.getHeader(MappingModePlugin.X_MAPPING_MODE_STATE);
        if(StringUtils.isBlank(accessToken)){
            log.debug("应用接口签名验证失败");
            throw new BizException("应用接口签名验证失败");
        }
        OauthInfo oauthInfo = applicationBootOauth2Client.getOauthInfo(accessToken);
        if(!StringUtils.equals(oauthInfo.getState(),state)){
            applicationBootOauth2Client.refreshOauthInfoCache(accessToken);
            log.debug("应用接口签名验证失败:"+accessToken);
            throw new BizException("应用接口签名验证失败");
        }

        request.setAttribute(APP_BOOT_MAPPING_MODE,true);//为SSO预留通行标记
        Environment environment = Environment.getEnvByEnvId(oauthInfo.getEnvironment());
        requestEnvironmentDecisionMaker.$$SetEnvironment(environment);
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex){
        requestEnvironmentDecisionMaker.$$Clear();
    }


}
