package cn.com.duiba.application.boot.api.remoteservice;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.domain.dto.Cluster;
import cn.com.duiba.application.boot.api.domain.dto.ClusterDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author liuyao
 */
@AdvancedFeignClient
public interface RemoteClusterService {

    List<ClusterDto> findAllClusters();

    List<Cluster> findClusters();

    Cluster findCluster(Long envId,String clusterKey);

    List<ClusterDto> findClusterByEnvironment(Environment environment);

    ClusterDto findOneCluster(Environment environment, String clusterKey);
    @Deprecated
    ClusterDto findByUK(Environment currentEnvironment, String clusterKey);

}
