package cn.com.duiba.application.boot.api.utils;

import cn.com.duiba.boot.exception.BizException;
import com.google.common.collect.Lists;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * @author liuyao
 */
public class ValidatorTool {

    private static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    /**
     * 获取校验的错误结果集
     * @param pojo 需要验证的对象
     * @return 错误集
     */
    public static <T> List<String> getValidatorErrorList(T pojo){
        Validator validator = factory.getValidator();
        Set<ConstraintViolation<T>> errorSet = validator.validate(pojo);
        if(errorSet.isEmpty()){
            return Collections.emptyList();
        }else{
            List<String> list = Lists.newLinkedList();
            for (ConstraintViolation<T> anErrorSet : errorSet) {
                list.add(anErrorSet.getMessage());
            }
            return list;
        }
    }

    /**
     * 校验对象
     * @param pojo 需要验证的对象
     */
    public static <T>void valid(T pojo) throws BizException {
        List<String> errorList = getValidatorErrorList(pojo);
        if(errorList.isEmpty()) {
            return;
        }
        throw new BizException(errorList.get(0));
    }

}
