package cn.com.duiba.application.boot.api.component.environment;

import com.alibaba.ttl.TransmittableThreadLocal;

import javax.annotation.Resource;
import java.util.Optional;

/**
 * 因为系统可能存在跨环境调用，EnvironmentDecisionMaker能够获取到发出请求的用户线程所处的环境
 * @author liuyao
 */
public class RequestEnvironmentDecisionMaker {

    private static final ThreadLocal<Environment> ENV_TTL = new ThreadLocal<>();

    @Resource
    private Environment currentEnvironment;
    /**
     * 获取当前的环境
     * 1.映射模式
     * 2.域名判断
     * @return 当前的请求的环境内容
     */
    public Environment getRequestEnvironment(){
        return Optional.ofNullable(ENV_TTL.get()).orElse(currentEnvironment);
    }

    public final void setEnvironment(Environment environment){
        ENV_TTL.set(environment);
    }

    public final void clear(){
        ENV_TTL.remove();
    }

}
