package cn.com.duiba.application.boot.api.component.mappingmode;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.annotation.Resource;

public class MappingModeServerConfiguration{

    @Bean
    public MappingModeServerInterceptor mappingModeServerInterceptor(){
        return new MappingModeServerInterceptor();
    }

    @Bean
    @ConditionalOnResource(resources = "/autoconfig_xss.properties")
    public MappingModeXssDefensivePolicy mappingModeXssDefensivePolicy(){
        return new MappingModeXssDefensivePolicy();
    }

    @Bean
    @Order(-3)
    @ConditionalOnBean(MappingModeServerInterceptor.class)
    public MappingModeServerWebMvcConfigurerAdapter mappingModeServerWebMvcConfigurerAdapter(){
        return new MappingModeServerWebMvcConfigurerAdapter();
    }

    public static class MappingModeServerWebMvcConfigurerAdapter implements WebMvcConfigurer {

        @Resource
        private MappingModeServerInterceptor mappingModeServerInterceptor;

        @Override
        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor(mappingModeServerInterceptor).addPathPatterns("/**");
        }

    }

}
