package cn.com.duiba.application.boot.api.component.oauth2;

import cn.com.duiba.application.boot.api.ApplicationProperties;
import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.domain.model.OauthInfo;
import cn.com.duiba.application.boot.api.domain.model.OauthToken;
import cn.com.duiba.application.boot.api.domain.model.OauthTokenRequest;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.Objects;

@Slf4j
public class ApplicationBootOauth2ClientForApi extends ApplicationBootOauth2Client {

    @CanAccessInsideNetwork
    @Resource
    public RestTemplate oauthRestTemplate;
    @Resource
    private ApplicationBootOauthProperties applicationBootOauthProperties;
    @Resource
    private ApplicationProperties applicationProperties;
    @Resource
    private Environment currentEnvironment;

    @Override
    public OauthToken loadOauthToken() {

        if(StringUtils.isBlank(applicationProperties.getSecret())){
            throw new RuntimeException("请配置 spring.application.secret,否则无法正常获取accessToken");
        }
        OauthTokenRequest request = new OauthTokenRequest();
        request.setAppAlias(applicationProperties.getApplicationName());
        request.setAppSecret(applicationProperties.getSecret());
        request.setEnvironment(currentEnvironment.getEnvId());
        request.setState(getState());

        OauthToken token = oauthRestTemplate.postForObject(buildHost("/oauth/getAccessToken"),request,OauthToken.class);
        if(Objects.isNull(token)){
            throw new RuntimeException("获取accessToken失败:OauthToken为空");
        }
        if(StringUtils.isBlank(token.getAccessToken())){
            throw new RuntimeException("获取accessToken失败:"+token.getMessage());
        }
        if(!StringUtils.equals(getState(),token.getState())){
            throw new RuntimeException("获取accessToken验证失败");
        }
        log.info("获取AccessToken:"+token.getAccessToken());
        return token;
    }

    @Override
    public OauthInfo loadOauthInfo(String accessToken) {
        return oauthRestTemplate.getForObject(buildHost("/oauth/authorize")+"?accessToken="+accessToken,OauthInfo.class);
    }

    private String buildHost(String path){
        return applicationBootOauthProperties.getHost() + path;
    }

}
