package cn.com.duiba.application.boot.api.component.stream;

import cn.com.duiba.application.boot.stream.annotation.StreamChannelInterceptor;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import org.springframework.core.annotation.Order;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;

import java.util.Objects;

@Order(1)
@StreamChannelInterceptor
public class CatInterceptor implements ChannelInterceptor {

    private ThreadLocal<Transaction> transactionThreadLocal = new ThreadLocal<>();

    @Override
    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        if(!CatUtils.isCatEnabled()){
            return message;
        }
        String binderName = ((AbstractMessageChannel)channel).getBeanName();
        Transaction transaction = Cat.newTransaction("Channel", binderName);
        transactionThreadLocal.set(transaction);
        return message;
    }

    @Override
    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {

        Transaction transaction = transactionThreadLocal.get();
        if(Objects.isNull(transaction)){
            return;
        }
        transactionThreadLocal.remove();
        if(Objects.nonNull(ex)){
            Cat.logError(ex);
            transaction.setStatus(ex);
        }else {
            transaction.setStatus(com.dianping.cat.message.Message.SUCCESS);
        }
        transaction.complete();
    }
}
