package cn.com.duiba.application.boot.api.component.application;


import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Aspect
public class ApplicationCacheService {

    private Cache<Long, ApplicationDto> applicationCacheForId = Caffeine.newBuilder().expireAfterWrite(1, TimeUnit.HOURS).build();

    private Cache<String, ApplicationDto> applicationCacheForAlias = Caffeine.newBuilder().expireAfterWrite(1, TimeUnit.HOURS).build();

    @Around(value = "execution(* cn.com.duiba.application.boot.api.remoteservice.RemoteApplicationService.findApplicationById(..))")
    public Object findApplicationById(ProceedingJoinPoint point) throws Throwable {

        Long appId = (Long)point.getArgs()[0];
        ApplicationDto application = applicationCacheForId.getIfPresent(appId);
        if(Objects.isNull(application)){
            application = (ApplicationDto)point.proceed();
            if(Objects.nonNull(application)){
                applicationCacheForId.put(appId,application);
            }
        }
        return application;
    }

    @Around(value = "execution(* cn.com.duiba.application.boot.api.remoteservice.RemoteApplicationService.getApplicationByAlias(..))")
    public Object getApplicationByAlias(ProceedingJoinPoint point) throws Throwable {

        String appAlias = (String)point.getArgs()[0];
        ApplicationDto application = applicationCacheForAlias.getIfPresent(appAlias);
        if(Objects.isNull(application)){
            application = (ApplicationDto)point.proceed();
            if(Objects.nonNull(application)){
                applicationCacheForAlias.put(appAlias,application);
            }
        }
        return application;
    }





}
