package cn.com.duiba.application.boot.api.component.environment;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Objects;

/**
 * 请使用Env
 * @author liuyao
 */

@Getter
public enum Environment implements Serializable {

    /**
     * 开发环境
     */
    DEV(1L,"dev","开发环境"),
    /**
     * 测试环境
     */
    TEST(2L,"test","测试环境"),
    /**
     * 预发环境
     */
    @Deprecated
    PRE(3L,"pre","预发环境"),
    /**
     * 生产环境
     * 预发环境降级为生产环境的集群：3 : pre
     **/
    PROD(3L,"prod","生产环境");

    private final Long id;
    private final String envId;
    private final String envName;

    Environment(Long id,String envId,String envName){
        this.id = id;
        this.envId = envId;
        this.envName = envName;
    }

    public static Environment getEnvByEnvId(String envId){
        Objects.requireNonNull(envId);
        switch (envId){
            case "dev":return DEV;
            case "test":return TEST;
            case "pre":return PRE;
            default:return PROD;
        }
    }

    public static Environment getEnvById(Long id){
        Objects.requireNonNull(id);
        int indexForInt = id.intValue();
        switch (indexForInt){
            case 1:return DEV;
            case 2:return TEST;
            default:return PROD;
        }
    }

    public static Environment getEnvByPrefix(String prefix){
        for(Environment env: values()){
            if(StringUtils.startsWith(prefix,env.getEnvId())){
                return env;
            }
        }
        return null;
    }

    public static Boolean isOnline(Environment environment){
        return Objects.equals(environment.getId(),3L);
    }

    public static Environment parseEnvironmentEnum(String profiles){
        if(StringUtils.isBlank(profiles)){
            return PROD;
        }
        for(Environment environment: values()){
            if(StringUtils.startsWith(profiles,environment.getEnvId())){
                return environment;
            }
        }
        return PROD;
    }

}
