package cn.com.duiba.application.boot.api.component.mappingmode;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.Order;

import java.util.Collection;
import java.util.Map;

/**
 * @author liuyao
 */
@Aspect
@Order(2)
public class MappingModeSleathPlugin implements RequestInterceptor {

    @Override
    public void apply(RequestTemplate template) {

        Map<String, Collection<String>> headers = template.headers();
        if(!headers.containsKey(MappingModePlugin.X_MAPPING_MODE_OAUTH2)){
            return;
        }
        //断开调用链
        template.header("X-B3-Flags","0");
    }

}
