package cn.com.duiba.application.boot.api.component.mappingmode;

import cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy.XssDefensivePolicy;
import cn.com.duibaboot.ext.autoconfigure.web.wrapper.XssHttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

import javax.servlet.http.HttpServletRequest;

/**
 * @author liuyao
 */
@Aspect
public class MappingModeXssDefensivePolicy extends XssDefensivePolicy {

    @Override
    public HttpServletRequest preprocessorRequest(HttpServletRequest request) {
        String accessToken = request.getHeader(MappingModePlugin.X_MAPPING_MODE_OAUTH2);
        if(StringUtils.isNotBlank(accessToken)){
            return request;
        }
        return super.preprocessorRequest(request);
    }

}
