package cn.com.duiba.application.boot.api.domain.dto;

import cn.com.duiba.application.boot.api.component.environment.ClusterKey;
import cn.com.duiba.application.boot.api.component.environment.Environment;
import lombok.Data;

import java.io.Serializable;

/**
 * @author liuyao
 */
@Data
public class ClusterDto implements Serializable {

    private static final long serialVersionUID = -5884194766730458008L;
    private Long id;
    private Environment environment;
    private String clusterKey;
    private String clusterName;

    public ClusterKey buildClusterKey(){
        ClusterKey key = new ClusterKey();
        key.setCluster(clusterKey);
        key.setEnvId(environment.getId());
        return key;
    }

}
