package cn.com.duiba.application.boot.api.component.mappingmode;

import cn.com.duibaboot.ext.autoconfigure.core.utils.PropertyResolver;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.*;

import java.util.Map;

@Slf4j
public class MappingModeEnvApplicationInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext>, Ordered {

    private static final String RIBBON_CONFIG_SUFFIX = ".ribbon.listOfServers";

    @Override
    public void initialize(ConfigurableApplicationContext application) {

        ConfigurableEnvironment environment = application.getEnvironment();

        String appName = environment.getProperty("spring.application.name");

        PropertyResolver resolver = new PropertyResolver((AbstractEnvironment)environment,"application.boot");
        MappingModeProperties properties= resolver.bindToConfig(MappingModeProperties.class);
        if(!properties.isMappingModeEnable()){
            return;
        }
        Map<String, Object> map = Maps.newHashMap();
        for(Map.Entry<String,String> entry:properties.getMappingMode().entrySet()){
            //自己对自己不能使用映射模式，会产生死循环
            if(StringUtils.equals(entry.getKey(),appName)){
                continue;
            }
            log.info("依赖应用"+entry.getKey()+"映射到:"+entry.getValue());
            map.put(entry.getKey()+RIBBON_CONFIG_SUFFIX,entry.getValue());
        }

        PropertySource<?> propertySource = new MapPropertySource("application.boot.mapping.mode",map);
        //最后的优先级最低
        MutablePropertySources mutablePropertySources = environment.getPropertySources();
        mutablePropertySources.addFirst(propertySource);

    }

    @Override
    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE + 20;
    }
}
