package cn.com.duiba.application.boot.api.remoteservice;

import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.application.boot.api.domain.params.CreateApplicationParams;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteApplicationService {

    /**
     * 创建应用
     **/
    @Deprecated
    void createApplication(ApplicationDto app) throws BizException;

    /**
     * 创建应用
     **/
    void addApplication(CreateApplicationParams params) throws BizException;

    /**
     * 更新应用
     **/
    void updateApplication(ApplicationDto app) throws BizException;

    /**
     * 注销应用
     **/
    void closeApplication(String appAlias) throws BizException;

    /**
     * 根据系统别名获取系统信息
     * @param appAlias 系统别名
     * @return 应用配置
     */
    ApplicationDto getApplicationByAlias(String appAlias);

    ApplicationDto findApplicationById(Long id);

    List<ApplicationDto> findAllApplication();

    List<ApplicationDto> findApplicationByIds(List<Long> appIds);

    List<ApplicationDto> findApplicationByAliaes(Set<String> appAliaes);

    List<ApplicationDto> findApplicationByOrgId(Long orgId);

}
