/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api;

import cn.com.duiba.application.boot.api.component.application.ApplicationCacheService;
import cn.com.duiba.application.boot.api.component.environment.ApplicationBootEnvironmentConfiguration;
import cn.com.duiba.application.boot.api.component.mappingmode.MappingModeConfiguration;
import cn.com.duiba.application.boot.api.component.oauth2.ApplicationBootOauth2Client;
import cn.com.duiba.application.boot.api.component.oauth2.ApplicationBootOauth2ClientForApi;
import cn.com.duiba.application.boot.api.component.oauth2.ApplicationBootOauthProperties;
import cn.com.duiba.application.boot.api.component.stream.interceptor.CatStreamConfiguration;
import cn.com.duiba.application.boot.api.component.stream.tee.TotalEnvironmentalEventConfiguration;
import org.apache.http.client.HttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@EnableConfigurationProperties(value={ApplicationBootOauthProperties.class})
@Import(value={ApplicationBootEnvironmentConfiguration.class, MappingModeConfiguration.class, TotalEnvironmentalEventConfiguration.class, CatStreamConfiguration.class})
public class ApplicationBootApiConfiguration {
    @Bean
    public ApplicationCacheService applicationCacheService() {
        return new ApplicationCacheService();
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationBootOauth2Client applicationBootOauth2Client() {
        return new ApplicationBootOauth2ClientForApi();
    }

    @Bean
    public RestTemplate oauthRestTemplate(HttpClient httpClient) {
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpRequestFactory.setConnectionRequestTimeout(30000);
        httpRequestFactory.setConnectTimeout(30000);
        httpRequestFactory.setReadTimeout(10000);
        httpRequestFactory.setHttpClient(httpClient);
        return new RestTemplate((ClientHttpRequestFactory)httpRequestFactory);
    }
}

