/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.oauth2;

import cn.com.duiba.application.boot.api.ApplicationProperties;
import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.oauth2.ApplicationBootOauth2Client;
import cn.com.duiba.application.boot.api.component.oauth2.ApplicationBootOauthProperties;
import cn.com.duiba.application.boot.api.domain.model.OauthInfo;
import cn.com.duiba.application.boot.api.domain.model.OauthToken;
import cn.com.duiba.application.boot.api.domain.model.OauthTokenRequest;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class ApplicationBootOauth2ClientForApi
extends ApplicationBootOauth2Client {
    private static final Logger log = LoggerFactory.getLogger(ApplicationBootOauth2ClientForApi.class);
    @CanAccessInsideNetwork
    @Resource
    public RestTemplate oauthRestTemplate;
    @Resource
    private ApplicationBootOauthProperties applicationBootOauthProperties;
    @Resource
    private ApplicationProperties applicationProperties;
    @Resource
    private Environment currentEnvironment;

    @Override
    public OauthToken loadOauthToken() {
        if (StringUtils.isBlank((String)this.applicationProperties.getSecret())) {
            throw new RuntimeException("\u8bf7\u914d\u7f6e spring.application.secret,\u5426\u5219\u65e0\u6cd5\u6b63\u5e38\u83b7\u53d6accessToken");
        }
        OauthTokenRequest request = new OauthTokenRequest();
        request.setAppAlias(this.applicationProperties.getApplicationName());
        request.setAppSecret(this.applicationProperties.getSecret());
        request.setEnvironment(this.currentEnvironment.getEnvId());
        request.setState(this.getState());
        OauthToken token = (OauthToken)this.oauthRestTemplate.postForObject(this.buildHost("/oauth/getAccessToken"), (Object)request, OauthToken.class, new Object[0]);
        if (Objects.isNull(token)) {
            throw new RuntimeException("\u83b7\u53d6accessToken\u5931\u8d25:OauthToken\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)token.getAccessToken())) {
            throw new RuntimeException("\u83b7\u53d6accessToken\u5931\u8d25:" + token.getMessage());
        }
        if (!StringUtils.equals((String)this.getState(), (String)token.getState())) {
            throw new RuntimeException("\u83b7\u53d6accessToken\u9a8c\u8bc1\u5931\u8d25");
        }
        log.info("\u83b7\u53d6AccessToken:" + token.getAccessToken());
        return token;
    }

    @Override
    public OauthInfo loadOauthInfo(String accessToken) {
        return (OauthInfo)this.oauthRestTemplate.getForObject(this.buildHost("/oauth/authorize") + "?accessToken=" + accessToken, OauthInfo.class, new Object[0]);
    }

    private String buildHost(String path) {
        return this.applicationBootOauthProperties.getHost() + path;
    }
}

