/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.stream.interceptor;

import cn.com.duiba.application.boot.stream.annotation.StreamChannelInterceptor;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import java.util.Objects;
import org.springframework.core.annotation.Order;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;

@Order(value=1)
@StreamChannelInterceptor
public class CatInterceptor
implements ChannelInterceptor {
    private ThreadLocal<Transaction> transactionThreadLocal = new ThreadLocal();

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        if (!CatUtils.isCatEnabled()) {
            return message;
        }
        String binderName = ((AbstractMessageChannel)channel).getBeanName();
        Transaction transaction = Cat.newTransaction((String)"Channel", (String)binderName);
        this.transactionThreadLocal.set(transaction);
        return message;
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        Transaction transaction = this.transactionThreadLocal.get();
        if (Objects.isNull(transaction)) {
            return;
        }
        this.transactionThreadLocal.remove();
        if (Objects.nonNull(ex)) {
            Cat.logError((Throwable)ex);
            transaction.setStatus((Throwable)ex);
        } else {
            transaction.setStatus("0");
        }
        transaction.complete();
    }
}

