/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.api.component.stream.tee;

import cn.com.duiba.application.boot.api.ApplicationProperties;
import cn.com.duiba.application.boot.api.component.environment.ClusterKey;
import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.environment.EnvironmentService;
import cn.com.duiba.application.boot.api.component.oauth2.ApplicationBootOauth2Client;
import cn.com.duiba.application.boot.api.component.stream.tee.SendLimit;
import cn.com.duiba.application.boot.api.component.stream.tee.TotalEnvironmentalEvent;
import cn.com.duiba.application.boot.stream.annotation.StreamListener;
import cn.com.duiba.application.boot.stream.support.StreamTemplate;
import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.Hessian2Serializer;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

public class TotalEnvironmentalEventService {
    private static final Logger log = LoggerFactory.getLogger(TotalEnvironmentalEventService.class);
    public static final String TEE_BINDING_NAME = "tee";
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private ApplicationBootOauth2Client applicationBootOauth2Client;
    @Resource
    private ApplicationProperties applicationProperties;
    @Resource
    private Environment currentEnvironment;
    @Resource
    private StreamTemplate streamTemplate;
    @Resource
    private EnvironmentService environmentService;

    public void publish(Object object) {
        Objects.requireNonNull(object);
        if (!(object instanceof Serializable)) {
            throw new RuntimeException("\u5168\u73af\u5883\u6d88\u606f[" + object.getClass().getName() + "]\u672a\u5b9e\u73b0\u5e8f\u5217\u5316\u63a5\u53e3");
        }
        TotalEnvironmentalEvent event = new TotalEnvironmentalEvent();
        this.charkSendLimit(object, this.currentEnvironment, this.applicationProperties.getApplicationName());
        event.setEventId(UUIDUtils.createUUID());
        event.setState(this.applicationBootOauth2Client.getState());
        event.setAccessToken(this.applicationBootOauth2Client.getAccessToken());
        event.setAppAlias(this.applicationProperties.getName());
        ClusterKey clusterKey = new ClusterKey();
        clusterKey.setCluster(this.environmentService.currentClusterKey());
        clusterKey.setEnvironment(this.currentEnvironment);
        event.setClusterKey(clusterKey);
        event.setClassName(object.getClass().getName());
        event.setPayloud(Hessian2Serializer.serialize((Object)object));
        this.streamTemplate.send(TEE_BINDING_NAME, (Object)event);
    }

    @StreamListener(value="tee")
    void accept(TotalEnvironmentalEvent event) {
        ClusterKey sourceClusterKey = event.getClusterKey();
        Assert.notNull((Object)sourceClusterKey, (String)"\u672a\u80fd\u8ffd\u5bfb\u4e8b\u4ef6\u6e90\u7684\u73af\u5883");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)event.getAppAlias()), (String)"\u672a\u80fd\u8ffd\u5bfb\u5230\u6e90\u5e94\u7528");
        if (Objects.isNull(event.getPayloud()) || StringUtils.isBlank((String)event.getClassName())) {
            return;
        }
        try {
            Class.forName(event.getClassName());
        }
        catch (ClassNotFoundException e) {
            log.debug("\u4e0d\u652f\u6301\u7c7b\u578b[" + event.getClassName() + "]\u6d88\u606f\u7684\u63a5\u6536");
            return;
        }
        Object payloud = Hessian2Serializer.deserialize((byte[])event.getPayloud());
        try {
            this.charkSendLimit(payloud, sourceClusterKey.getEnvironment(), event.getAppAlias());
        }
        catch (Exception e) {
            log.debug("\u65e0\u6cd5\u63a5\u6536", (Throwable)e);
            return;
        }
        this.applicationContext.publishEvent(payloud);
    }

    public void charkSendLimit(Object event, Environment environment, String appName) {
        Assert.isTrue((environment != null ? 1 : 0) != 0, (String)"\u8de8\u73af\u5883\u6d88\u606f\u73af\u5883\u53c2\u6570\u7f3a\u5931");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)appName), (String)"\u8de8\u73af\u5883\u6d88\u606f\u5e94\u7528\u53c2\u6570\u7f3a\u5931");
        SendLimit sendLimit = (SendLimit)AnnotationUtils.findAnnotation(event.getClass(), SendLimit.class);
        if (Objects.isNull(sendLimit)) {
            return;
        }
        HashSet appAlias = Sets.newHashSet((Object[])sendLimit.appAlias());
        if (!appAlias.isEmpty() && !appAlias.contains(appName)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u7cfb\u7edf\u4e0d\u652f\u6301\u4e8b\u4ef6[" + event.getClass().getName() + "]\u7684\u53d1\u5e03");
        }
        HashSet envs = Sets.newHashSet((Object[])sendLimit.environment());
        if (!envs.isEmpty() && !envs.contains(environment)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u73af\u5883\u4e0d\u652f\u6301\u4e8b\u4ef6[" + event.getClass().getName() + "]\u7684\u53d1\u5e03");
        }
    }
}

