/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.stream.binding;

import cn.com.duiba.application.boot.stream.binder.Binder;
import cn.com.duiba.application.boot.stream.binder.BinderMessageHandler;
import cn.com.duiba.application.boot.stream.binder.BinderMessageProducer;
import cn.com.duiba.application.boot.stream.binding.Binding;
import cn.com.duiba.application.boot.stream.binding.ChannelBindingEvent;
import cn.com.duiba.application.boot.stream.binding.ProducerBinding;
import cn.com.duiba.application.boot.stream.binding.SubscribableBinding;
import cn.com.duiba.application.boot.stream.channel.ChannelFactoryBean;
import cn.com.duiba.application.boot.stream.channel.ChannelKey;
import cn.com.duiba.application.boot.stream.channel.ChannelType;
import cn.com.duiba.application.boot.stream.channel.ProducerMessageChannel;
import cn.com.duiba.application.boot.stream.config.BindingProperties;
import cn.com.duiba.application.boot.stream.config.BindingServiceProperties;
import cn.com.duiba.application.boot.stream.config.ConsumerProperties;
import cn.com.duiba.application.boot.stream.config.ProducerProperties;
import cn.com.duiba.application.boot.stream.configuration.BinderTypeRegistry;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.core.Ordered;
import org.springframework.messaging.support.AbstractMessageChannel;

public class BindingService
implements DisposableBean,
ApplicationRunner,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(BindingService.class);
    private Map<ChannelKey, Binding> bindingCache = Maps.newConcurrentMap();
    @Resource
    private BindingServiceProperties bindingServiceProperties;
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private BinderTypeRegistry binderTypeRegistry;

    private synchronized void createBinding() {
        if (!this.bindingCache.isEmpty()) {
            return;
        }
        Map<String, BindingProperties> bindingPropertiesMap = this.bindingServiceProperties.getBindings();
        for (String bindingName : bindingPropertiesMap.keySet()) {
            ConsumerProperties consumerProperties;
            BindingProperties bindingProperties = bindingPropertiesMap.get(bindingName);
            ProducerProperties producerProperties = bindingProperties.getProducer();
            if (producerProperties.getEnable().booleanValue()) {
                ChannelKey channelKey = new ChannelKey();
                channelKey.setChannelType(ChannelType.OUTPUT);
                channelKey.setBindingName(bindingName);
                this.bindProducer(channelKey);
            }
            if (!(consumerProperties = bindingProperties.getConsumer()).getEnable().booleanValue()) continue;
            ChannelKey channelKey = new ChannelKey();
            channelKey.setChannelType(ChannelType.INPUT);
            channelKey.setBindingName(bindingName);
            this.bindConsumer(channelKey);
        }
    }

    @EventListener(value={ChannelBindingEvent.class})
    public void channelBindingSubscribable(ChannelBindingEvent event) {
        log.info(event.getChannelKey() + "\u7ed1\u5b9a\u5b8c\u6210");
    }

    public Binding getBinding(ChannelKey key) {
        if (!this.bindingCache.containsKey(key)) {
            throw new NullPointerException(key + "\u5bf9\u5e94\u7684\u901a\u9053\u4e0d\u5b58\u5728");
        }
        return this.bindingCache.get(key);
    }

    private void bindProducer(ChannelKey key) {
        Map<String, BindingProperties> bindings = this.bindingServiceProperties.getBindings();
        BindingProperties bindingProperties = bindings.get(key.getBindingName());
        bindingProperties.setBindingName(key.getBindingName());
        Binder binder = this.findBinder(bindingProperties.getBinder());
        BinderMessageHandler messageHandler = binder.createProducerMessageHandler(bindingProperties);
        ProducerBinding binding = new ProducerBinding();
        binding.setMessageHandler(messageHandler);
        String producerChannelBeanName = ChannelFactoryBean.getBeanNameByBindingName(key);
        ProducerMessageChannel channel = (ProducerMessageChannel)((Object)this.applicationContext.getBean(producerChannelBeanName, ProducerMessageChannel.class));
        binding.setMessageChannel(channel);
        this.bindingCache.put(key, binding);
        ChannelBindingEvent event = new ChannelBindingEvent();
        event.setChannelKey(key);
        this.applicationContext.publishEvent((Object)event);
        binding.doBinding();
    }

    private void bindConsumer(ChannelKey key) {
        Map<String, BindingProperties> bindings = this.bindingServiceProperties.getBindings();
        BindingProperties bindingProperties = bindings.get(key.getBindingName());
        bindingProperties.setBindingName(key.getBindingName());
        Binder binder = this.findBinder(bindingProperties.getBinder());
        BinderMessageProducer messageProducer = binder.createConsumerEndpoint(bindingProperties);
        SubscribableBinding subscribableBinding = new SubscribableBinding();
        subscribableBinding.setMessageProducer(messageProducer);
        String consumerChannelBeanName = ChannelFactoryBean.getBeanNameByBindingName(key);
        AbstractMessageChannel channel = (AbstractMessageChannel)this.applicationContext.getBean(consumerChannelBeanName, AbstractMessageChannel.class);
        subscribableBinding.setMessageChannel(channel);
        this.bindingCache.put(key, subscribableBinding);
        ChannelBindingEvent event = new ChannelBindingEvent();
        event.setChannelKey(key);
        this.applicationContext.publishEvent((Object)event);
        subscribableBinding.doBinding();
    }

    public void destroy() {
        for (Binding binding : this.bindingCache.values()) {
            binding.stop();
        }
    }

    private Binder findBinder(String binderName) {
        String beanName = this.binderTypeRegistry.findBeanNameByBinderType(binderName);
        return (Binder)this.applicationContext.getBean(beanName, Binder.class);
    }

    public void run(ApplicationArguments args) {
        this.createBinding();
    }

    public int getOrder() {
        return -10;
    }
}

