/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.stream.channel;

import cn.com.duiba.application.boot.stream.channel.ChannelInterceptorBox;
import cn.com.duiba.application.boot.stream.channel.ChannelKey;
import cn.com.duiba.application.boot.stream.channel.ChannelType;
import cn.com.duiba.application.boot.stream.channel.ProducerMessageChannel;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.messaging.support.ExecutorSubscribableChannel;
import org.springframework.util.Assert;

public class ChannelFactoryBean
implements FactoryBean<AbstractMessageChannel> {
    private static final String PRODUCER_BEAN_NAME_SUFFIX = "MessageChannel";
    private static final String CONSUMER_BEAN_NAME_SUFFIX = "SubscribableChannel";
    private ChannelKey channelKey;
    private ChannelInterceptorBox channelInterceptorBox;

    public static String getBeanNameByBindingName(ChannelKey channelKey) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)channelKey.getBindingName()), (String)"\u7ed1\u5b9a\u540d\u79f0\u7f3a\u5931");
        Assert.isTrue((boolean)Objects.nonNull((Object)channelKey.getChannelType()), (String)"\u901a\u9053\u7c7b\u578b\u7f3a\u5931");
        StringBuilder builder = new StringBuilder(channelKey.getBindingName());
        if (channelKey.getChannelType() == ChannelType.OUTPUT) {
            builder.append(PRODUCER_BEAN_NAME_SUFFIX);
        } else if (channelKey.getChannelType() == ChannelType.INPUT) {
            builder.append(CONSUMER_BEAN_NAME_SUFFIX);
        }
        return builder.toString();
    }

    public AbstractMessageChannel getObject() {
        String beanName = ChannelFactoryBean.getBeanNameByBindingName(this.channelKey);
        Object channel = null;
        if (this.channelKey.getChannelType() == ChannelType.INPUT) {
            channel = new ExecutorSubscribableChannel();
        }
        if (this.channelKey.getChannelType() == ChannelType.OUTPUT) {
            channel = new ProducerMessageChannel();
        }
        if (Objects.isNull(channel)) {
            throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u901a\u9053\u7c7b\u578b");
        }
        channel.setBeanName(beanName);
        channel.setInterceptors(this.channelInterceptorBox.getChannelInterceptors());
        return channel;
    }

    public Class<?> getObjectType() {
        return AbstractMessageChannel.class;
    }

    public ChannelInterceptorBox getChannelInterceptorBox() {
        return this.channelInterceptorBox;
    }

    public void setChannelInterceptorBox(ChannelInterceptorBox channelInterceptorBox) {
        this.channelInterceptorBox = channelInterceptorBox;
    }

    public ChannelKey getChannelKey() {
        return this.channelKey;
    }

    public void setChannelKey(ChannelKey channelKey) {
        this.channelKey = channelKey;
    }
}

