/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.stream.converter;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeType;

public class ObjectStringMessageConverter
extends AbstractMessageConverter {
    public ObjectStringMessageConverter() {
        super(new MimeType("text", "*", Charset.forName("UTF-8")));
        this.setStrictContentTypeMatch(true);
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        return this.supportsMimeType(message.getHeaders());
    }

    protected boolean supportsMimeType(@Nullable MessageHeaders headers) {
        MimeType mimeType = this.getMimeType(headers);
        if (mimeType != null) {
            for (MimeType current : this.getSupportedMimeTypes()) {
                if (!current.getType().equals(mimeType.getType())) continue;
                return true;
            }
        }
        return super.supportsMimeType(headers);
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        if (message.getPayload() != null) {
            if (message.getPayload() instanceof byte[]) {
                if (byte[].class.isAssignableFrom(targetClass)) {
                    return message.getPayload();
                }
                return new String((byte[])message.getPayload(), StandardCharsets.UTF_8);
            }
            if (byte[].class.isAssignableFrom(targetClass)) {
                return message.getPayload().toString().getBytes(StandardCharsets.UTF_8);
            }
            return message.getPayload();
        }
        return null;
    }

    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        if (payload != null) {
            if (payload instanceof byte[]) {
                return payload;
            }
            return payload.toString().getBytes();
        }
        return null;
    }
}

