package cn.com.duiba.application.boot.stream.annotation;

import org.springframework.core.annotation.AliasFor;
import org.springframework.messaging.handler.annotation.MessageMapping;

import java.lang.annotation.*;

@Target({ ElementType.METHOD, ElementType.ANNOTATION_TYPE })
@Retention(RetentionPolicy.RUNTIME)
@MessageMapping
@Documented
public @interface StreamListener {

    /**
     * The name of the binding target (e.g. channel) that the method subscribes to.
     * @return the name of the binding target.
     */
    @AliasFor("target")
    String value() default "";

    /**
     * The name of the binding target (e.g. channel) that the method subscribes to.
     * @return the name of the binding target.
     */
    @AliasFor("value")
    String target() default "";


}
