/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.stream.configuration;

import cn.com.duiba.application.boot.stream.binder.BinderFactoryBean;
import cn.com.duiba.application.boot.stream.binder.BinderType;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class BinderTypeRegistry
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(BinderTypeRegistry.class);
    private Map<String, BinderType> binderTypes = new HashMap<String, BinderType>();
    private Map<String, String> beanNameMap = Maps.newHashMap();
    private ConfigurableApplicationContext configurableApplicationContext;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.scanBinderTypes();
        this.reflectionBinderBuilderBeanName(registry);
    }

    private void scanBinderTypes() {
        ClassLoader classLoader = this.configurableApplicationContext.getClassLoader();
        try {
            Enumeration<URL> resources = Objects.requireNonNull(classLoader).getResources("META-INF/stream.binders");
            if (resources == null || !resources.hasMoreElements()) {
                log.debug("Failed to locate 'META-INF/stream.binders' resources on the classpath. Assuming standard boot 'META-INF/spring.factories' configuration is used");
                return;
            }
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                UrlResource resource = new UrlResource(url);
                for (BinderType binderType : BinderTypeRegistry.parseBinderConfigurations(classLoader, (Resource)resource)) {
                    this.binderTypes.put(binderType.getName(), binderType);
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new BeanCreationException("Cannot create binder factory:", (Throwable)e);
        }
    }

    private void reflectionBinderBuilderBeanName(BeanDefinitionRegistry registry) {
        for (Map.Entry<String, BinderType> entry : this.binderTypes.entrySet()) {
            BinderType binderType = entry.getValue();
            String binderTypeName = entry.getKey();
            Class<?> binderFactoryBeanClass = binderType.getBinderFactoryBeanClass();
            if (Objects.isNull(binderFactoryBeanClass)) continue;
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(binderFactoryBeanClass);
            builder.addPropertyValue("binderName", (Object)binderTypeName);
            String beanName = binderTypeName + "Biner";
            registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
            this.beanNameMap.put(binderTypeName, beanName);
        }
    }

    private static Collection<BinderType> parseBinderConfigurations(ClassLoader classLoader, Resource resource) throws IOException, ClassNotFoundException {
        Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
        ArrayList<BinderType> parsedBinderConfigurations = new ArrayList<BinderType>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String binderType = (String)entry.getKey();
            String binderFactoryBeanClassName = (String)entry.getValue();
            if (StringUtils.isEmpty((Object)binderFactoryBeanClassName)) continue;
            Class binderFactoryClassName = ClassUtils.forName((String)binderFactoryBeanClassName, (ClassLoader)classLoader);
            if (!BinderFactoryBean.class.isAssignableFrom(binderFactoryClassName)) {
                throw new RuntimeException("binder\u7684\u63d0\u4f9b\u8005\u5fc5\u987b\u5b9e\u73b0BinderFactoryBean\u63a5\u53e3");
            }
            parsedBinderConfigurations.add(new BinderType(binderType, binderFactoryClassName));
        }
        return parsedBinderConfigurations;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.isInstanceOf(ConfigurableApplicationContext.class, (Object)applicationContext);
        this.configurableApplicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public String findBeanNameByBinderType(String binderType) {
        if (!this.beanNameMap.containsKey(binderType)) {
            throw new IllegalArgumentException("\u6ca1\u6709Binder[" + binderType + "]\u7684\u63d0\u4f9b\u8005");
        }
        return this.beanNameMap.get(binderType);
    }
}

