/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.stream.configuration;

import cn.com.duiba.application.boot.stream.annotation.StreamChannelInterceptor;
import cn.com.duiba.application.boot.stream.binding.BindingService;
import cn.com.duiba.application.boot.stream.binding.StreamListenerAnnotationBeanPostProcessor;
import cn.com.duiba.application.boot.stream.channel.ChannelBeanFactoryPostProcessor;
import cn.com.duiba.application.boot.stream.channel.ChannelInterceptorBox;
import cn.com.duiba.application.boot.stream.config.BindingServiceProperties;
import cn.com.duiba.application.boot.stream.config.SpringIntegrationProperties;
import cn.com.duiba.application.boot.stream.configuration.BinderTypeRegistry;
import cn.com.duiba.application.boot.stream.support.StreamTemplate;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.config.EnableIntegration;
import org.springframework.messaging.support.ChannelInterceptor;

@Configuration
@Import(value={BinderTypeRegistry.class, ChannelBeanFactoryPostProcessor.class})
@EnableConfigurationProperties(value={BindingServiceProperties.class, SpringIntegrationProperties.class})
@EnableIntegration
public class StreamBinderConfiguration {
    private static final Logger log = LoggerFactory.getLogger(StreamBinderConfiguration.class);

    @Bean
    public BindingService bindingService() {
        return new BindingService();
    }

    @Bean
    public ChannelInterceptorBox channelInterceptorBox(@Autowired(required=false) List<ChannelInterceptor> channelInterceptors) {
        ChannelInterceptorBox box = new ChannelInterceptorBox();
        if (Objects.isNull(channelInterceptors)) {
            return box;
        }
        for (ChannelInterceptor interceptor : channelInterceptors) {
            StreamChannelInterceptor streamChannelInterceptor = (StreamChannelInterceptor)AnnotationUtils.findAnnotation(interceptor.getClass(), StreamChannelInterceptor.class);
            if (!Objects.nonNull(streamChannelInterceptor)) continue;
            box.addChannelInterceptor(interceptor);
        }
        return box;
    }

    @Bean
    public static StreamListenerAnnotationBeanPostProcessor streamListenerAnnotationBeanPostProcessor() {
        return new StreamListenerAnnotationBeanPostProcessor();
    }

    @Bean
    public StreamTemplate streamTemplate() {
        return new StreamTemplate();
    }
}

