/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.stream.converter;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConversionException;

class ApplicationJsonMessageMarshallingConverter
extends MappingJackson2MessageConverter {
    private final Map<ParameterizedTypeReference<?>, JavaType> typeCache = new ConcurrentHashMap();

    ApplicationJsonMessageMarshallingConverter(@Nullable ObjectMapper objectMapper) {
        if (objectMapper != null) {
            this.setObjectMapper(objectMapper);
        }
    }

    protected Object convertToInternal(Object payload, @Nullable MessageHeaders headers, @Nullable Object conversionHint) {
        if (payload instanceof byte[]) {
            return payload;
        }
        if (payload instanceof String) {
            return ((String)payload).getBytes(StandardCharsets.UTF_8);
        }
        return super.convertToInternal(payload, headers, conversionHint);
    }

    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        Object result = null;
        if (conversionHint instanceof MethodParameter) {
            Class conversionHintType = ((MethodParameter)conversionHint).getParameterType();
            if (Message.class.isAssignableFrom(conversionHintType)) {
                conversionHint = null;
            } else if (((MethodParameter)conversionHint).getGenericParameterType() instanceof ParameterizedType) {
                ParameterizedTypeReference forType = ParameterizedTypeReference.forType((Type)((MethodParameter)conversionHint).getGenericParameterType());
                result = this.convertParameterizedType(message, targetClass, forType);
            }
        } else if (conversionHint instanceof ParameterizedTypeReference) {
            result = this.convertParameterizedType(message, targetClass, (ParameterizedTypeReference)conversionHint);
        }
        if (result == null) {
            result = message.getPayload() instanceof byte[] && targetClass.isAssignableFrom(String.class) ? new String((byte[])message.getPayload(), StandardCharsets.UTF_8) : super.convertFromInternal(message, targetClass, conversionHint);
        }
        return result;
    }

    private Object convertParameterizedType(Message<?> message, Class<?> targetClass, ParameterizedTypeReference<?> conversionHint) {
        ObjectMapper objectMapper = this.getObjectMapper();
        Object payload = message.getPayload();
        try {
            JavaType type = this.typeCache.get(conversionHint);
            if (type == null) {
                type = objectMapper.getTypeFactory().constructType(conversionHint.getType());
                this.typeCache.put(conversionHint, type);
            }
            if (payload instanceof byte[]) {
                return objectMapper.readValue((byte[])payload, type);
            }
            if (payload instanceof String) {
                return objectMapper.readValue((String)payload, type);
            }
            return null;
        }
        catch (IOException e) {
            throw new MessageConversionException("Cannot parse payload ", (Throwable)e);
        }
    }
}

