/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.stream.binding;

import cn.com.duiba.application.boot.stream.annotation.StreamListener;
import cn.com.duiba.application.boot.stream.binding.DispatchingStreamListenerMessageHandler;
import cn.com.duiba.application.boot.stream.binding.StreamListenerHandlerMethodMapping;
import cn.com.duiba.application.boot.stream.binding.StreamListenerMessageHandler;
import cn.com.duiba.application.boot.stream.binding.StreamListenerScanRegistrar;
import cn.com.duiba.application.boot.stream.channel.ChannelFactoryBean;
import cn.com.duiba.application.boot.stream.channel.ChannelKey;
import cn.com.duiba.application.boot.stream.channel.ChannelType;
import cn.com.duiba.application.boot.stream.config.SpringIntegrationProperties;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

public class StreamListenerAnnotationBeanPostProcessor
implements BeanPostProcessor,
SmartInitializingSingleton,
ApplicationContextAware {
    private ConfigurableApplicationContext applicationContext;
    @Resource(name="integrationListMessageHandlerMethodFactory")
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    @Resource
    private SpringIntegrationProperties springIntegrationProperties;
    private final MultiValueMap<String, StreamListenerHandlerMethodMapping> mappedListenerMethods = new LinkedMultiValueMap();

    public final Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Method[] uniqueDeclaredMethods;
        Class<?> targetClass;
        Class<?> clazz = targetClass = AopUtils.isAopProxy((Object)bean) ? AopUtils.getTargetClass((Object)bean) : bean.getClass();
        if (!this.checkPackage(targetClass.getPackage())) {
            return bean;
        }
        for (Method method : uniqueDeclaredMethods = ReflectionUtils.getUniqueDeclaredMethods(targetClass)) {
            String bindingName;
            StreamListener streamListener = (StreamListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, StreamListener.class);
            if (streamListener == null || method.isBridge() || StringUtils.isBlank((CharSequence)(bindingName = streamListener.value()))) continue;
            this.mappedListenerMethods.add((Object)bindingName, (Object)new StreamListenerHandlerMethodMapping(bean, method, bindingName));
        }
        return bean;
    }

    public void afterSingletonsInstantiated() {
        StandardEvaluationContext evaluationContext = IntegrationContextUtils.getEvaluationContext((BeanFactory)this.applicationContext.getBeanFactory());
        for (Map.Entry mappedBindingEntry : this.mappedListenerMethods.entrySet()) {
            ArrayList<DispatchingStreamListenerMessageHandler.ConditionalStreamListenerMessageHandlerWrapper> handlers = new ArrayList<DispatchingStreamListenerMessageHandler.ConditionalStreamListenerMessageHandlerWrapper>();
            for (StreamListenerHandlerMethodMapping mapping : (List)mappedBindingEntry.getValue()) {
                InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(mapping.getTargetBean(), this.checkProxy(mapping.getMethod(), mapping.getTargetBean()));
                StreamListenerMessageHandler streamListenerMessageHandler = new StreamListenerMessageHandler(invocableHandlerMethod, true, this.springIntegrationProperties.getMessageHandlerNotPropagatedHeaders());
                streamListenerMessageHandler.setApplicationContext((ApplicationContext)this.applicationContext);
                streamListenerMessageHandler.setBeanFactory((BeanFactory)this.applicationContext.getBeanFactory());
                if (StringUtils.isNotBlank((CharSequence)mapping.getOutputChannel())) {
                    streamListenerMessageHandler.setOutputChannelName(mapping.getOutputChannel());
                }
                streamListenerMessageHandler.afterPropertiesSet();
                handlers.add(new DispatchingStreamListenerMessageHandler.ConditionalStreamListenerMessageHandlerWrapper(null, streamListenerMessageHandler));
            }
            if (handlers.size() > 1) {
                for (DispatchingStreamListenerMessageHandler.ConditionalStreamListenerMessageHandlerWrapper handler : handlers) {
                    Assert.isTrue((boolean)handler.isVoid(), (String)"If multiple @StreamListener methods are listening to the same binding target, none of them may return a value");
                }
            }
            AbstractReplyProducingMessageHandler handler = handlers.size() > 1 || ((DispatchingStreamListenerMessageHandler.ConditionalStreamListenerMessageHandlerWrapper)handlers.get(0)).getCondition() != null ? new DispatchingStreamListenerMessageHandler(handlers, (EvaluationContext)evaluationContext) : handlers.get(0).getStreamListenerMessageHandler();
            handler.setBeanFactory((BeanFactory)this.applicationContext);
            handler.setApplicationContext((ApplicationContext)this.applicationContext);
            handler.afterPropertiesSet();
            this.applicationContext.getBeanFactory().registerSingleton(handler.getClass().getSimpleName() + handler.hashCode(), (Object)handler);
            ChannelKey channelKey = new ChannelKey();
            channelKey.setBindingName((String)mappedBindingEntry.getKey());
            channelKey.setChannelType(ChannelType.INPUT);
            String subscribableChannelBeanName = ChannelFactoryBean.getBeanNameByBindingName(channelKey);
            ((SubscribableChannel)this.applicationContext.getBean(subscribableChannelBeanName, SubscribableChannel.class)).subscribe((MessageHandler)handler);
        }
        this.mappedListenerMethods.clear();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    private Method checkProxy(Method methodArg, Object bean) {
        Method method = methodArg;
        if (AopUtils.isJdkDynamicProxy((Object)bean)) {
            try {
                Class[] proxiedInterfaces;
                method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                for (Class iface : proxiedInterfaces = ((Advised)bean).getProxiedInterfaces()) {
                    try {
                        method = iface.getMethod(method.getName(), method.getParameterTypes());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@StreamListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()), ex);
            }
        }
        return method;
    }

    private boolean checkPackage(Package pkg) {
        if (pkg == null) {
            return false;
        }
        String packageName = pkg.getName();
        for (String whitePackage : StreamListenerScanRegistrar.getScanPackages()) {
            if (!StringUtils.startsWith((CharSequence)packageName, (CharSequence)whitePackage)) continue;
            return true;
        }
        return false;
    }
}

