/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.application.boot.ui.resource;

import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.environment.EnvironmentService;
import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.application.boot.api.remoteservice.RemoteApplicationService;
import cn.com.duiba.application.boot.ui.UiBootProperties;
import cn.com.duiba.application.boot.ui.resource.UiBootResourceManager;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"${application.boot.ui.root-path:'/ui'}/uiboot"})
public class UiBootDataController {
    @Resource
    private RemoteApplicationService remoteApplicationService;
    @Resource
    private UiBootProperties uiBootProperties;
    @Resource
    private RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker;
    @Resource
    private EnvironmentService environmentService;
    @Resource
    private UiBootResourceManager uiBootResourceManager;

    @GetMapping(value={"/findAllApplication"})
    public JSONArray findAllApplication() {
        List apps = this.remoteApplicationService.findAllApplication();
        JSONArray applications = new JSONArray();
        for (ApplicationDto system : apps) {
            JSONObject app = new JSONObject();
            app.put("alias", (Object)system.getAppAlias());
            app.put("name", (Object)system.getAppName());
            app.put("id", (Object)system.getId());
            applications.add((Object)app);
        }
        return applications;
    }

    @RequestMapping(value={"/index.html"}, method={RequestMethod.GET})
    public ModelAndView serveIndex() {
        ModelAndView model = new ModelAndView("index");
        model.addObject("rootPath", (Object)this.uiBootProperties.getRootPath());
        model.addObject("webTitle", (Object)this.uiBootProperties.getWebTitle());
        Environment Environment2 = this.requestEnvironmentDecisionMaker.getRequestEnvironment();
        model.addObject("environment", (Object)Environment2.getEnvId());
        model.addObject("cluster", (Object)this.environmentService.currentClusterKey());
        model.addObject("version", (Object)this.uiBootProperties.getVersion());
        return model;
    }

    @RequestMapping(value={"/{version}/main.js"}, method={RequestMethod.GET}, consumes={"application/javascript"})
    public ModelAndView mainJs(@PathVariable String version) {
        Map<String, String> modules = this.uiBootResourceManager.getAllModule();
        ArrayList list = Lists.newArrayList();
        list.addAll(modules.keySet());
        String lists = JSONObject.toJSONString((Object)list);
        String maps = JSONObject.toJSONString(modules);
        ModelAndView model = new ModelAndView("main.js");
        model.addObject("rootMoudles", (Object)lists);
        model.addObject("rootMoudleMap", (Object)maps);
        model.addObject("version", (Object)version);
        return model;
    }
}

