package cn.com.duiba.application.boot.ui.mume;

import cn.com.duiba.application.boot.ui.UiBootProperties;
import com.alibaba.fastjson.JSONArray;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class FileMumeLoader implements MumeLoader {

    private volatile List<UIBootMume> mumes = Collections.emptyList();

    @javax.annotation.Resource
    private UiBootProperties uiBootProperties;
    @javax.annotation.Resource
    private ApplicationContext applicationContext;

    @PostConstruct
    public void init() throws IOException {
        Resource resource = applicationContext.getResource(uiBootProperties.getMumeResource());
        if(!resource.exists()){
            String message = "路径："+uiBootProperties.getMumeResource()+"对应的文件不存在";
            throw new IOException(message);
        }
        CharSource charSource = Resources.asCharSource(resource.getURL(), StandardCharsets.UTF_8);
        String context = charSource.read();
        mumes = JSONArray.parseArray(context, UIBootMume.class);
    }

    @Override
    public List<UIBootMume> loadUIMume() {
        return mumes;
    }

    @Override
    public Long mumeVersion() {
        return uiBootProperties.getMumeVersion();
    }
}
