package cn.com.duiba.application.boot.ui.resource;


import cn.com.duiba.application.boot.api.component.environment.Environment;
import cn.com.duiba.application.boot.api.component.environment.EnvironmentService;
import cn.com.duiba.application.boot.api.component.environment.RequestEnvironmentDecisionMaker;
import cn.com.duiba.application.boot.api.domain.dto.ApplicationDto;
import cn.com.duiba.application.boot.api.remoteservice.RemoteApplicationService;
import cn.com.duiba.application.boot.ui.UiBootProperties;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

import static org.springframework.web.bind.annotation.RequestMethod.GET;

@RestController
@RequestMapping(value = "${application.boot.ui.root-path:'/ui'}/uiboot")
public class UiBootDataController {

    @Resource
    private RemoteApplicationService remoteApplicationService;
    @Resource
    private UiBootProperties uiBootProperties;
    @Resource
    private RequestEnvironmentDecisionMaker requestEnvironmentDecisionMaker;
    @Resource
    private EnvironmentService environmentService;
    @Resource
    private UiBootResourceManager uiBootResourceManager;

    @GetMapping(value = "/findAllApplication")
    public JSONArray findAllApplication(){

        List<ApplicationDto> apps = remoteApplicationService.findAllApplication();
        JSONArray applications = new JSONArray();
        for(ApplicationDto system:apps){
            JSONObject app = new JSONObject();
            app.put("alias",system.getAppAlias());
            app.put("name",system.getAppName());
            app.put("id",system.getId());
            applications.add(app);
        }
        return applications;
    }

    @RequestMapping(value = "/index.html", method = GET)
    public ModelAndView serveIndex() {
        ModelAndView model = new ModelAndView("index");
        model.addObject("rootPath",uiBootProperties.getRootPath());
        model.addObject("webTitle",uiBootProperties.getWebTitle());

        Environment Environment = requestEnvironmentDecisionMaker.getRequestEnvironment();

        model.addObject("environment",Environment.getEnvId());
        model.addObject("cluster",environmentService.currentClusterKey());
        model.addObject("version",uiBootProperties.getVersion());
        return model;
    }



    @RequestMapping(value = "/{version}/main.js", method = GET,consumes = "application/javascript")
    public ModelAndView mainJs(@PathVariable String version) {

        Map<String,String> modules = uiBootResourceManager.getAllModule();

        List<String> list = Lists.newArrayList();
        list.addAll(modules.keySet());
        String lists = JSONObject.toJSONString(list);
        String maps =  JSONObject.toJSONString(modules);

        ModelAndView model = new ModelAndView("main.js");
        model.addObject("rootMoudles",lists);
        model.addObject("rootMoudleMap",maps);
        model.addObject("version",version);
        return model;
    }


}
