package cn.com.duiba.application.boot.ui.resource;

import cn.com.duiba.application.boot.ui.mume.MumeLoader;
import cn.com.duiba.application.boot.ui.mume.UIBootMume;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@RequestMapping(value = "${application.boot.ui.root-path:'/ui'}/uiboot/mume")
public class UiBootMumeController {

    @Resource
    private MumeLoader mumeLoader;

    @GetMapping("/findUIBootMume")
    public List<UIBootMume> findUIBootMume(){
        return mumeLoader.loadUIMume();
    }

    @GetMapping("/mumeVersion")
    public Long mumeVersion(){
        return mumeLoader.mumeVersion();
    }



}
