/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.bigdata.common.biz.service;

import cn.com.duiba.bigdata.common.biz.dto.KeyValueDto;
import cn.com.duiba.bigdata.common.biz.enums.HologresShowTypeEnum;
import cn.com.duiba.bigdata.common.biz.enums.OperatorsEnum;
import cn.com.duiba.bigdata.common.biz.enums.TuiaDimensionEnum;
import cn.com.duiba.bigdata.common.biz.enums.tables.HologresTableEnum;
import cn.com.duiba.bigdata.common.biz.form.HoloQueryForm;
import cn.com.duiba.bigdata.common.biz.interfaces.DimensionEnum;
import cn.com.duiba.bigdata.common.biz.interfaces.MetricEnum;
import cn.com.duiba.bigdata.common.biz.utils.BusinessEnumUtil;
import cn.com.duiba.bigdata.common.biz.utils.DateFormatUtil;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlService {
    private static final Logger log = LoggerFactory.getLogger(SqlService.class);
    public static final String ABTEST_PLAN_ID = TuiaDimensionEnum.ABTEST_PLAN_ID.toString();
    public static final String ABTEST_GROUP_ID = TuiaDimensionEnum.ABTEST_GROUP_ID.toString();

    public static String getQuerySql(HoloQueryForm form, List<Object> metricList, Object metric, int businessType) throws Exception {
        String groupBySql;
        String conditionSQL;
        String metricCondition;
        if (!SqlService.dimCheck(businessType, form.getDimensionList(), metric)) {
            return null;
        }
        StringBuilder sb = new StringBuilder("select ");
        String dimensionSql = SqlService.getDimensionSql(form.getDataShowType(), form.getDimensionList(), form.getConditionList(), businessType);
        if (StringUtils.isNotBlank((CharSequence)dimensionSql)) {
            sb.append(dimensionSql);
        }
        String metricSql = SqlService.getMetricSql(metricList, metric, businessType);
        sb.append(metricSql);
        String tableName = SqlService.getHologresTable(metric, businessType);
        sb.append(" from ").append(tableName);
        long startTimeLong = DateFormatUtil.parse("yyyy-MM-dd HH:mm:ss", form.getStartTime()).getTime() / 1000L;
        long endTimeLong = DateFormatUtil.parse("yyyy-MM-dd HH:mm:ss", form.getEndTime()).getTime() / 1000L;
        long startDay = Long.parseLong(form.getStartTime().substring(0, 10).replaceAll("-", ""));
        long endDay = Long.parseLong(form.getEndTime().substring(0, 10).replaceAll("-", ""));
        sb.append(" where date_partition >= ").append(startDay).append(" and date_partition <= ").append(endDay);
        if (HologresTableEnum.INSTANCE.exist(tableName, "UNIX_TIME")) {
            sb.append(" and unix_time >= ").append(startTimeLong).append(" and unix_time <= ").append(endTimeLong);
        }
        if (StringUtils.isNotBlank((CharSequence)(metricCondition = SqlService.getMetricCondition(metric, businessType)))) {
            sb.append(" and ").append(metricCondition);
        }
        if (StringUtils.isNotBlank((CharSequence)(conditionSQL = SqlService.getConditionSQL(form.getConditionList(), tableName, businessType)))) {
            sb.append(conditionSQL);
        }
        if (StringUtils.isNotBlank((CharSequence)(groupBySql = SqlService.getGroupBySql(form.getDataShowType(), form.getDimensionList(), businessType)))) {
            sb.append(" group by ").append(groupBySql);
        }
        return sb.toString();
    }

    private static boolean dimCheck(int businessType, List<String> dimensionList, Object metric) {
        if (CollectionUtils.isEmpty(dimensionList)) {
            return true;
        }
        String tableName = SqlService.getHologresTable(metric, businessType);
        for (String dim : dimensionList) {
            if (HologresTableEnum.INSTANCE.exist(tableName, dim)) continue;
            return false;
        }
        return true;
    }

    private static String getDimensionSql(String dataShowType, List<String> dimensionList, List<KeyValueDto> conditionList, int businessType) {
        StringBuilder sb = new StringBuilder();
        if (!HologresShowTypeEnum.ALL.toString().equals(dataShowType)) {
            HologresShowTypeEnum showTypeEnum = HologresShowTypeEnum.valueOf(dataShowType);
            sb.append(showTypeEnum.getSqlSegment()).append(" as ").append(showTypeEnum.getFieldName()).append(", ");
        }
        if (CollectionUtils.isEmpty(dimensionList)) {
            return sb.toString();
        }
        for (String dim : dimensionList) {
            DimensionEnum dimensionEnum = Objects.requireNonNull(BusinessEnumUtil.getDimensionEnum(businessType, dim));
            if (dim.equals(ABTEST_PLAN_ID)) {
                sb.append("'").append(SqlService.getABTestPlanId(conditionList)).append("'").append(" as ").append(dimensionEnum.getResultFieldName()).append(", ");
                continue;
            }
            if (dim.equals(ABTEST_GROUP_ID)) {
                sb.append(SqlService.getAbtestGroupIdSql(conditionList)).append(" as ").append(dimensionEnum.getResultFieldName()).append(", ");
                continue;
            }
            sb.append(dimensionEnum.getTableFieldName()).append(" as ").append(dimensionEnum.getResultFieldName()).append(", ");
        }
        return sb.toString();
    }

    private static String getABTestPlanId(List<KeyValueDto> conditionList) {
        String value = "";
        for (KeyValueDto dto : conditionList) {
            if (!dto.getKey().toString().equals(ABTEST_PLAN_ID)) continue;
            value = dto.getValue().toString();
        }
        return value;
    }

    private static String getAbtestGroupIdSql(List<KeyValueDto> conditionList) {
        StringBuilder sb = new StringBuilder();
        String planId = SqlService.getABTestPlanId(conditionList);
        if (StringUtils.isNotBlank((CharSequence)planId)) {
            sb.append(TuiaDimensionEnum.ABTEST_JSON.getTableFieldName()).append(OperatorsEnum.JSONB.getSymbol().replace("${value}", planId));
        }
        return sb.toString();
    }

    private static String getAbtestGroupIdSql(String planId) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)planId)) {
            sb.append(TuiaDimensionEnum.ABTEST_JSON.getTableFieldName()).append(OperatorsEnum.JSONB.getSymbol().replace("${value}", planId));
        }
        return sb.toString();
    }

    private static String getMetricSql(List<Object> metricList, Object targetMetric, int businessType) {
        StringBuilder sb = new StringBuilder();
        for (Object metric : metricList) {
            sb.append(SqlService.getMetricSql(metric, targetMetric, businessType));
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    private static String getMetricSql(Object metric, Object targetMetric, int businessType) {
        StringBuilder sb = new StringBuilder();
        if (metric instanceof String) {
            MetricEnum metricEnum = Objects.requireNonNull(BusinessEnumUtil.getMetricEnum(businessType, metric.toString()));
            sb.append(SqlService.getMetricSql(metric, targetMetric, metricEnum));
        } else if (metric instanceof List) {
            List metricGroup = (List)metric;
            for (String subMetric : metricGroup) {
                MetricEnum metricEnum = Objects.requireNonNull(BusinessEnumUtil.getMetricEnum(businessType, subMetric));
                sb.append(SqlService.getMetricSql(metric, targetMetric, metricEnum));
            }
        }
        return sb.toString();
    }

    private static String getMetricSql(Object metric, Object targetMetric, MetricEnum metricEnum) {
        StringBuilder sb = new StringBuilder();
        String metricSql = metric != targetMetric ? "0" : metricEnum.getMetricSql();
        sb.append(metricSql).append(" as ").append(metricEnum.getResultFieldName()).append(",");
        return sb.toString();
    }

    private static String getHologresTable(Object metric, int businessType) {
        String metricName = "";
        if (metric instanceof String) {
            metricName = metric.toString();
        } else if (metric instanceof List) {
            List metricGroup = (List)metric;
            metricName = (String)metricGroup.get(0);
        }
        return Objects.requireNonNull(BusinessEnumUtil.getMetricEnum(businessType, metricName)).getTableName();
    }

    private static String getMetricCondition(Object metric, int businessType) {
        if (metric instanceof String) {
            return Objects.requireNonNull(BusinessEnumUtil.getMetricEnum(businessType, metric.toString())).getCondition();
        }
        if (metric instanceof List) {
            List metricGroup = (List)metric;
            return Objects.requireNonNull(BusinessEnumUtil.getMetricEnum(businessType, (String)metricGroup.get(0))).getCondition();
        }
        return null;
    }

    private static String getConditionSQL(List<KeyValueDto> conditionList, String tableName, int businessType) {
        if (CollectionUtils.isEmpty(conditionList)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String planId = SqlService.getABTestPlanId(conditionList);
        for (KeyValueDto pair : conditionList) {
            SqlService.getConditionSQLValue(sb, pair, tableName, planId, businessType);
        }
        return sb.toString();
    }

    private static void getConditionSQLValue(StringBuilder sb, KeyValueDto pair, String tableName, String planId, int businessType) {
        if (pair == null || pair.getKey() == null) {
            return;
        }
        String key = pair.getKey().toString();
        DimensionEnum dimensionEnum = Objects.requireNonNull(BusinessEnumUtil.getDimensionEnum(businessType, key));
        if (!HologresTableEnum.INSTANCE.exist(tableName, key)) {
            return;
        }
        if (key.equals(ABTEST_PLAN_ID)) {
            return;
        }
        if (key.equals(ABTEST_GROUP_ID)) {
            String groupIdSql = SqlService.getAbtestGroupIdSql(planId);
            String groupId = SqlService.getPairValue(pair.getValue(), dimensionEnum.getFieldType());
            sb.append(" and ").append(groupIdSql).append(OperatorsEnum.IN.getSymbol().replace("${value}", groupId));
            return;
        }
        String tableFieldName = dimensionEnum.getTableFieldName();
        Object value = pair.getValue();
        String symbol = OperatorsEnum.valueOf(pair.getSymbol()).getSymbol();
        if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
            if (pair.getSymbol().equals(OperatorsEnum.IS_NULL.toString()) || pair.getSymbol().equals(OperatorsEnum.IS_NOT_NULL.toString())) {
                sb.append(" and ").append(tableFieldName).append(symbol);
            }
        } else {
            String pairValue = SqlService.getPairValue(value, dimensionEnum.getFieldType());
            if (pair.getSymbol().equals(OperatorsEnum.IN.toString()) || pair.getSymbol().equals(OperatorsEnum.NOT_IN.toString()) || pair.getSymbol().equals(OperatorsEnum.ARRAY.toString())) {
                symbol = symbol.replace("${value}", pairValue);
                sb.append(" and ").append(tableFieldName).append(symbol);
            }
        }
    }

    private static String getPairValue(Object pairValue, String fieldType) {
        if (pairValue instanceof List) {
            List list = (List)pairValue;
            StringBuilder sb = new StringBuilder();
            for (Object value : list) {
                if ("String".equalsIgnoreCase(fieldType) || "array-string".equalsIgnoreCase(fieldType)) {
                    sb.append("'").append(value.toString()).append("'").append(",");
                    continue;
                }
                sb.append(value.toString()).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        if ("String".equalsIgnoreCase(fieldType) || "array-string".equalsIgnoreCase(fieldType)) {
            return "'" + pairValue.toString() + "'";
        }
        return pairValue.toString();
    }

    private static String getGroupBySql(String dataShowType, List<String> dimensionList, int businessType) {
        StringBuilder sb = new StringBuilder();
        if (!HologresShowTypeEnum.ALL.toString().equals(dataShowType)) {
            sb.append(HologresShowTypeEnum.valueOf(dataShowType).getSqlSegment()).append(",");
        }
        if (CollectionUtils.isNotEmpty(dimensionList)) {
            for (String dim : dimensionList) {
                DimensionEnum dimensionEnum = Objects.requireNonNull(BusinessEnumUtil.getDimensionEnum(businessType, dim));
                if (dim.equals(ABTEST_PLAN_ID) || dim.equals(ABTEST_GROUP_ID)) {
                    sb.append(dimensionEnum.getResultFieldName()).append(",");
                    continue;
                }
                sb.append(dimensionEnum.getTableFieldName()).append(",");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

