package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author xugf 2019-11-15
 */
@Data
public class DeviceTagDto implements Serializable {

    private static final long serialVersionUID = -3421179710920791900L;

    //离线DMP人群包（本期新做的）
    private List<String> offlineTagPackage;

    //行业人群包
    private List<String> businessTagPackage;

    //基础属性标签
    private AttributeTagDto attributeTag;

    //商业兴趣标签
    private List<String> interestTag;

    //广告行业兴趣人群标签
    private List<BusinessTagDto> businessTag;

    //设备7天内点击过的广告列表
    private List<String> clickAdvertList;

    //imei号对应的基础标签
    private String imeiBasicTags;

    //第三方dmp厂家人群包
    private List<String> externalPackage;

    //系统算法推荐人群包 (key:应用场景的名称 value:人群包列表，多个人群包用 "," 分隔)
    private Map<String, String> algPackage;
}
