package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;

@Data
public class DeviceOfflineFeatureDto implements Serializable {

    private static final long serialVersionUID = -612884047088862081L;

    //活动访问相关特征
    //历史活动访问次数（28天）
    private Integer activityRequest;

    //一周内活动访问次数
    private Integer weekActivityRequest;

    //历史距离上一次活动访问时间间隔（28天）
    private Integer intervalActivityRequest;

    //历史活动访问频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String periodActivityRequest;


    //活动参与相关特征
    //历史活动参与次数
    private Integer activityJoin;

    //一周内活动参与次数
    private Integer weekActivityJoin;

    //历史距离上一次活动参与时间间隔（天）
    private Integer intervalActivityJoin;

    //历史活动参与频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String periodActivityJoin;


    //发券特征
    //f413007 上一次发券行业
    private String lastLaunchTrade;

    //f413008 上一次发券是否点击
    private Integer clickLaunchTrade;

    //券点击相关特征
    //历史不同行业上券点击数量
    private String clickTrade;

    //一周内不同行业上券点击数量
    private String weekClickTrade;

    //历史距离上一次券点击时间间隔（天）
    private Integer intervalClickTrade;

    //历史券点击频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String periodClickTrade;

    //上一次券点击行业
    private String lastClickTrade;

    //上一次券点击是否转化
    private Integer effectClickTrade;


    //券前端转化相关特征
    //历史不同行业上转化数量
    private String effectTrade;

    //一周内不同行业上转化数量
    private String weekEffectTrade;

    //历史距离上一次转化时间间隔（天）
    private Integer intervalEffectTrade;

    //历史转化频繁时段（凌晨、早上、上午、中午、下午、晚上、深夜）
    private String periodEffectTrade;

    //上一次转化行业
    private String lastEffectTrade;


    // 风控行为
    //f434001 历史累计核单失败次数
    private Integer vouchFailed;

    //f434004 历史拒付费次数
    private Integer reject;
}
