package cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto;

import lombok.Data;

import java.io.Serializable;


@Data
public class DeviceSequenceDto implements Serializable {
    private static final long serialVersionUID = -316102112618444133L;

    // 用户行为序
    private String clickAdIds; // 用户最近点击的广告id，逗号分隔, 和待打分的广告id交叉作为新特征f830001
    private String clickAcIds; // 用户最近点击的广告主id，逗号分隔, 和待打分的广告所属广告主id交叉作为新特征f830002
    private String clickReIds; // 用户最近点击的资源id，逗号分隔, 和待打分的广告所属资源id交叉作为新特征f830003
    private String clickTrIds; // 用户最近点击的广告二级行业id，逗号分隔, 和待打分的广告所属广告二级行业id交叉作为新特征f830004

    // 用户行为序 deviceId
    private String convertAdverts; // 831001	用户广告转化序列
    private String convertAccounts; // 831002	用户广告主转化序列
    private String convertResources; // 831003	用户资源转化序列
    private String convertTrades; // 831004	用户行业转化序列

    private String bConvertAdverts; // 832001	用户广告后端转化序列
    private String bConvertAccounts; // 832002	用户广告主后端转化序列
    private String bConvertResources; // 832003	用户资源后端转化序列
    private String bConvertTrades; // 832004	用户行业后端转化序列


    //用户订单序列
    private Long dayOrderRank; //f.实时 f601000-f601001
    private Long orderRank; // f602000-f602001
    private Long lastChargeNums; // f608000-f608001
}
