package cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.AdxFeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.FeatureDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.OneIdFeatureOfflineDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteOneIdFeatureService {

    /**
     * 获取device对应的实时和离线特征
     *
     * @param oneId oneId
     * @param oneIdType 1:真实设备号的oneId,2:虚拟设备号的oneId
     * @param timeout 熔断时间 毫秒
     * @return OneIdFeatureOfflineDto
     */
    OneIdFeatureOfflineDto getOneIdFeature(String oneId, Integer oneIdType, Long timeout);
}
